% donnees de base ST, n,m
% agragation des unites d'information liees (cos < coup1)
% (sorte d'analyse cluster)
% liW nombre de composantes
% W contient par ligne: 
% le nombre de composante et le no de chacune d'entre elle
% P contient par colonne les unites reellement liees
% Isol contient les unites isolees
% on pourrait calculer les longueurs une fois pour toute (corrcoef)
% ou toutes les correlations puis choisir les meilleures !

% symetrisation
V = ST + ST';

% mise a 1
V = V & 1;

% calcul des normes des lignes
poids = sqrt(sum(V,2));
 
coup1 = 0.3;

% unites triees par poids decroissant
% 1ere colonne les normes
% 2eme colonne no des UI
V = flipud(sortrows ([poids (1:n)' V])); 
%V = sortrows ([poids (1:n)' V]); 


% exclusion des isolees (norme = 1)
lmax = n;
%for i = 1:n;
%  if V(i,1) == 1
%    lmax = i-1;
%    break;
%  end
% end

%if lmax ~= n,
%  Isol = V(lmax+1:n,2) ;
%end

W = zeros(lmax,lmax+1);
P = zeros(lmax+1,lmax);

% demarrage de l'agregation
% unite W courante: 

noW = V(1,2);
%nbre de W definie 
liW = 1;
W(1,1) = 1;
W(1,2) = noW;

% P les composantes en vertical (1e ligne:les poids)
P(:,1) = [V(1,1) V(1,3:lmax+2)]';

for i=2:lmax,
  % produit de tous les W avec vi
  AUX = (((V(i,3:lmax+2) * P(2:lmax+1,1:liW) ) ./ P(1,1:liW) )./ V(i,1));
  LP = [AUX' (1:liW)'];
  LP = flipud(sortrows(LP));
  
  if(LP(1,1) > coup1)

  % agreger V(i,:) a W(LP(1,2)) et  a P recalculer la norme de P(:,LP(1,2))
  
    ct = LP(1,2);
   
    W(ct,1) = W(ct,1)+1;
    W(ct,W(ct,1)+1) = V(i,2);
    P(2:lmax+1,ct) = (P(2:lmax+1,ct) + V(i,3:lmax+2)') & 1;
    P(1,ct) = sqrt(sum(P(2:lmax+1,ct)));
  else 
    noW = V(i,2);
    liW = liW+1;
    W(liW,1) = 1;
    W(liW,2) = noW;
    P(:,liW) = [V(i,1) V(i,3:lmax+2)]';
   end
end


W = W(1:liW,:);
W1 = flipud(sortrows (W));

P = P(:,1:liW);